//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiCheckButtonBase {
    id : uiCheckBox

    property alias text : label.text

    property UiCheckBoxVisualStyle visualStyle : null

    implicitHeight : box.height
    implicitWidth : {
        if (label.text.length > 0) {
            return box.width + box.spacing + label.implicitWidth + box.margin;
        }

        return box.width;
    }

    baselineOffset : label.y + label.baselineOffset

    Rectangle {
        id : box

        property int spacing : uiCheckBox.visualStyle ?
                                   uiCheckBox.visualStyle.spacing : 6
        readonly property int margin  : 2

        anchors.verticalCenter : parent.verticalCenter

        width : 18
        height : 18
        color : UiColors.getColor(UiColors.White)
        border {
            width : 1
            color : UiColors.getColor(UiColors.ControlGrey20)
        }

        Loader {
            anchors.centerIn : parent
            sourceComponent : {
                if (uiCheckBox.checkState === Qt.Checked) {
                    return checkmark;
                } else if (uiCheckBox.checkState === Qt.PartiallyChecked) {
                    return square;
                } else {
                    return null;
                }
            }
        }
    }

    Component {
        id : checkmark

        UiColorizedImage {
            source : "qrc:/ui/images/checkmark.png"
            color : {
                if (!uiCheckBox.enabled) {
                    return UiColors.getColor(UiColors.DisabledLightGrey13);
                } else if (uiCheckBox.readOnly) {
                    return UiColors.getColor(UiColors.MediumGrey33);
                } else {
                    return "transparent";
                }
            }
        }
    }

    Component {
        id : square

        Rectangle {
            width : box.width - 8
            height : box.width - 8
            color : {
                if (!uiCheckBox.enabled) {
                    return UiColors.getColor(UiColors.DisabledLightGrey13);
                } else if (uiCheckBox.readOnly) {
                    return UiColors.getColor(UiColors.MediumGrey33);
                } else {
                    return "#545454";
                }
            }
        }
    }

    UiText {
        id : label

        visible : text.length > 0
        width : uiCheckBox.width - box.width - box.spacing - box.margin
        text : uiCheckBox.text
        anchors {
            left : box.right
            leftMargin : box.spacing
            verticalCenter : parent.verticalCenter
        }
    }

    UiFocusRect {
        anchors.centerIn : label
        width : label.width + box.margin * 2
        height : label.height + 1
        target : uiCheckBox
        enabled : label.text.length > 0
    }

    states: [
        State {
            name : "disabled"
            when : !uiCheckBox.enabled || uiCheckBox.readOnly

            PropertyChanges {
                target : box
                border.color : UiColors.getColor(UiColors.DisabledLightGrey13)
            }
        },
        State {
            name : "pressed"
            when : uiCheckBox.pressed

            PropertyChanges {
                target : box
                color : uiCheckBox.visualStyle ?
                            uiCheckBox.visualStyle.selectionColor :
                            UiColors.getColor(UiColors.SelectionGreen)
                border.color : uiCheckBox.visualStyle ?
                                   uiCheckBox.visualStyle.selectionBorderColor :
                                   UiColors.getColor(
                                       UiColors.DarkerSelectionGreen)
            }
        },
        State {
            name : "hovered"
            when : uiCheckBox.hovered || uiCheckBox.activeFocus
            changes : [
                PropertyChanges {
                    target : box
                    color : uiCheckBox.visualStyle ?
                                uiCheckBox.visualStyle.hoverColor :
                                               UiColors.getColor(
                                    UiColors.HoverGreen)
                    border.color : uiCheckBox.visualStyle ?
                                       uiCheckBox.visualStyle.hoverBorderColor :
                                       UiColors.getColor(
                                           UiColors.DarkerHoverGreen)
                }
            ]
        }
    ]
}
